// XISLOutputFSM.cpp: CXISLOutputFSM NX̃Cve[V
//
//////////////////////////////////////////////////////////////////////

#include "stdafx.h"
#include "ib.h"
#include "XISLOutputFSM.h"
#include "XISLVar.h"
#include "XISLExcItem.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif

//////////////////////////////////////////////////////////////////////
// \z/
//////////////////////////////////////////////////////////////////////

CXISLOutputFSM::CXISLOutputFSM()
{
	m_nTagType = ID_TAG_OUTPUT;
	m_nBmpID = IDB_FSM;
	m_nOutputType = ID_OUTPUTTYPE_AGENT;

	m_nParam1 = 0;
	m_nParam2 = 0;

	m_pTextList = NULL;
}

CXISLOutputFSM::~CXISLOutputFSM()
{
	if(m_pTextList)
	{
		InitTextList();
		delete m_pTextList;
	}
}

CXISLOutputFSM::CXISLOutputFSM(const CXISLOutputFSM &cpXISL)
{
	m_nTagType = cpXISL.m_nTagType;
	m_strXISL = cpXISL.m_strXISL;
	m_rectBMP = cpXISL.m_rectBMP;
	m_nBmpID = cpXISL.m_nBmpID;
	m_htreeItem = cpXISL.m_htreeItem;
	m_pParentTag = cpXISL.m_pParentTag;

	m_nOutputEvent = cpXISL.m_nOutputEvent;
	m_nOutputType = cpXISL.m_nOutputType;

	m_strMaskID = cpXISL.m_strMaskID;
	m_nParam1 = cpXISL.m_nParam1;
	m_nParam2 = cpXISL.m_nParam2;
	m_bEndSync = cpXISL.m_bEndSync;
	m_strText  = cpXISL.m_strText;
}

CXISLOutputFSM& CXISLOutputFSM::operator=(const CXISLOutputFSM &cpXISL)
{
	if(&cpXISL != this)
	{
		m_nTagType = cpXISL.m_nTagType;
		m_strXISL = cpXISL.m_strXISL;
		m_rectBMP = cpXISL.m_rectBMP;
		m_nBmpID = cpXISL.m_nBmpID;
		m_htreeItem = cpXISL.m_htreeItem;
		m_pParentTag = cpXISL.m_pParentTag;

		m_nOutputEvent = cpXISL.m_nOutputEvent;
		m_nOutputType = cpXISL.m_nOutputType;

		m_strMaskID = cpXISL.m_strMaskID;
		m_nParam1 = cpXISL.m_nParam1;
		m_nParam2 = cpXISL.m_nParam2;
		m_bEndSync = cpXISL.m_bEndSync;
		m_strText  = cpXISL.m_strText;
	}
	return *this;
}

//BOOL CXISLOutputFSM::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
//@\@Fc[Rg[XISL^Oo^
//@FCTreeCtrl *pTree  :o^c[Rg[
//		  HTREEITEM hParent :eڂ̃nh
//ԂlFBOOL@FTRUE@sFFALSE
BOOL CXISLOutputFSM::RegistXISLTree(CTreeCtrl *pTree,HTREEITEM hParent)
{
	TVINSERTSTRUCTA tvs;
	TVITEMA tvi;

	tvs.hInsertAfter = TVI_LAST;
	tvi.mask = TVIF_TEXT | TVIF_PARAM | TVIF_IMAGE | TVIF_SELECTEDIMAGE;
	tvs.hParent = hParent;

	//c[ɓo^
	tvi.pszText = XISL_TAG_NAME[ID_TAG_OUTPUT];
	tvi.lParam = (LPARAM)this;
	tvi.iImage = 0;
	tvi.iSelectedImage = 1;
	tvs.item = tvi;
	hParent = pTree->InsertItem(&tvs);
	m_htreeItem = hParent;

	return TRUE;
}

void CXISLOutputFSM::InitTextList()
{
	if(m_pTextList == NULL)
		return;

	//_~[CXISLVar͍폜
	while(!m_pTextList->IsEmpty())
	{
		CXISLVar *pVar = (CXISLVar*)m_pTextList->RemoveHead();
		if(pVar->IsDummy())
			delete pVar;
		else
			pVar->ReferCount(FALSE);
	}
}
LPCTSTR CXISLOutputFSM::GetText(CString &strText)
{
	if(m_nOutputEvent != ID_FSMEVENT_SPEECH)
		ASSERT(NULL);

	m_strText.Empty();
	strText.Empty();
	CString strVarName;
	POSITION pos = m_pTextList->GetHeadPosition();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)m_pTextList->GetNext(pos);
		if(pVar->IsDummy())
		{
			m_strText += pVar->GetVarName();
			strText += pVar->GetVarName();
		}
		else
		{
			m_strText += " $";
			m_strText += pVar->GetVarName();
			m_strText += " ";

			pVar->GetVarNameEx(strVarName);
			strText += "<value expr=\"";
			strText += strVarName;
			strText += "\"/>";
		}
	}

	return m_strText;
}

BOOL CXISLOutputFSM::SetText(CPtrList *pTextList,int nExpression,BOOL bEndSync)
{
	InitTextList();
	if(m_pTextList==NULL)
		m_pTextList = new CPtrList;

	POSITION pos = pTextList->GetHeadPosition();
	while(pos)
	{
		CXISLVar *pVar = (CXISLVar*)pTextList->GetNext(pos);
		m_pTextList->AddTail(pVar);
		pVar->ReferCount(TRUE);
	}

	m_nOutputEvent = ID_FSMEVENT_SPEECH;
	m_bEndSync = bEndSync;
	m_nParam1 = nExpression;

	return TRUE;
}

BOOL CXISLOutputFSM::SetText(LPCTSTR lpszTextList,int nExpression,BOOL bEndSync)
{
	if(m_pTextList==NULL)
		m_pTextList = new CPtrList;

	CString strText = lpszTextList;
	int nStart=0;
	CXISLVar *pText=NULL;
	CString strVarName;
	BOOL bOK = TRUE;
	CXISLExcItem *pExcItem = (CXISLExcItem*)m_pParentTag->GetParentExcTag();
	while(1)
	{
		if(strText.IsEmpty())
			break;
		nStart = strText.Find("<value",0);

		if(nStart == -1)
		{
			pText = new CXISLVar;
			pText->SetAttribute(strText,"",FALSE,TRUE);
			m_pTextList->AddTail(pText);
			break;
		}
		if(nStart != 0)
		{
			pText = new CXISLVar;
			pText->SetAttribute(strText.Left(nStart),"",FALSE,TRUE);
			m_pTextList->AddTail(pText);
			strText.Delete(0,nStart);
		}
		else
		{
			nStart = strText.Find("\"/>");
			if(nStart == -1)
			{
				AfxMessageBox("<value>̕^O܂",MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
				bOK = FALSE;
				break;
			}
			strVarName = strText.Left(nStart+1);
			int nIndex = strVarName.Find("expr",0);
			if(nStart == -1)
			{
				AfxMessageBox("<value>expr܂",MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
				bOK = FALSE;
				break;
			}
			
			nIndex = strVarName.Find("\"",nIndex);
			int nEnd = strVarName.ReverseFind('"');
			strVarName = strVarName.Mid(nIndex+1,nEnd-nIndex-1);
			CXISLVar *pVar = pExcItem->m_pLocalVar->FindVarWithParent(strVarName);
			if(pVar == NULL)
			{
				AfxMessageBox("݂Ȃϐw肳܂",MB_OK|MB_APPLMODAL|MB_ICONINFORMATION,0);
				bOK = FALSE;
				break;
			}
			strText.Delete(0,nStart+2);
			m_pTextList->AddTail(pVar);
			pVar->ReferCount(TRUE);
		}
	}

	if(!bOK)
		InitTextList();
	else
	{
		m_nOutputEvent = ID_FSMEVENT_SPEECH;
		m_bEndSync = bEndSync;
		m_nParam1 = nExpression;
	}

	return bOK;
}

LPCTSTR CXISLOutputFSM::GetCharactor()
{
	if(m_nOutputEvent == ID_TTSEVENT_SCHAR)
		return m_strMaskID;

	ASSERT(NULL);
	return 0;
}

BOOL CXISLOutputFSM::SetCharactor(LPCTSTR lpszMaskID)
{
	if(m_pTextList)
	{
		delete m_pTextList;
		m_pTextList = NULL;
	}
	m_nOutputEvent = ID_FSMEVENT_CHARACTER;
	m_strMaskID = lpszMaskID;
	return TRUE;
}

BOOL CXISLOutputFSM::SetExpression(int nExpression,int nDur)
{
	m_nOutputEvent = ID_FSMEVENT_EXPRESSION;

	if(ID_FSMEXPRESSION_HAPPY <= nExpression && nExpression >= ID_FSMEXPRESSION_NEUTRAL)
		ASSERT(NULL);

	m_nParam1 = nExpression;
	m_nParam2 = nDur;
	return TRUE;
}

void CXISLOutputFSM::GetExpression(int &nExpression,int &nDur)
{
	if(m_nOutputEvent != ID_FSMEVENT_EXPRESSION && m_nOutputEvent != ID_FSMEVENT_SPEECH)
		ASSERT(NULL);

	nExpression = m_nParam1;
	nDur = m_nParam2;
}

BOOL CXISLOutputFSM::SetMotion(int nAction,int nID)
{
	m_nOutputEvent = ID_FSMEVENT_MOTION;

	m_nParam1 = nAction;
	m_nParam2 = nID;
	return TRUE;
}

void CXISLOutputFSM::GetMotion(int &nAction,int &nID)
{
	if(m_nOutputEvent != ID_FSMEVENT_MOTION)
		ASSERT(NULL);

	nAction = m_nParam1;
	nID = m_nParam2;
}

BOOL CXISLOutputFSM::SetAutonomous(int nAction)
{
	m_nOutputEvent = ID_FSMEVENT_AUTONOMOUS;

	m_nParam1 = nAction;
	m_nParam2 = -1;
	return TRUE;
}

int CXISLOutputFSM::GetAutonomous()
{
	if(m_nOutputEvent != ID_FSMEVENT_AUTONOMOUS)
		ASSERT(NULL);

	return m_nParam1;
}

//void CXISLOutputTTS::GetDrawString(CString &strText)
//@\@F\peLXg擾
//@FCString :i[p
//ԂlFvoid
void CXISLOutputFSM::GetDrawString(CString &strText)
{
	switch(m_nOutputEvent)
	{
	case ID_FSMEVENT_CHARACTER:
		strText = "LN^ύX:\n";
		strText += m_strMaskID;
		break;
	case ID_FSMEVENT_SPEECH:
		GetText(strText);
		strText.Insert(0,"speech:\n");
		break;
	case ID_FSMEVENT_AUTONOMOUS:
		strText = "̐ݒ\n";
		strText += FSM_AUTONOMOUS_PARAM[m_nParam1];
		break;
	case ID_FSMEVENT_EXPRESSION:
		strText = "\\n";
		strText += FSM_EXPRESSION_PARAM[m_nParam1];
		break;
	case ID_FSMEVENT_MOTION:
		strText = "瓮\n";
		strText += FSM_MOTION_PARAM[m_nParam1];
		break;
	default:
		ASSERT(NULL);
	}
}

//LPCTSTR CXISLOutputFSM::GetXISLString()
//@\@FactionȉXISLԂ
//@F
//ԂlFLPCTSTRCXISL
LPCTSTR CXISLOutputFSM::GetXISLString()
{
	CString strOutputType = XISL_OUTPUT_TYPE[m_nOutputType];
	CString strOutputEvent = XISL_OUTPUT_EVENT[m_nOutputEvent];

	m_strXISL = "<output type=\"" + strOutputType;
	m_strXISL += "\" event=\"";
	m_strXISL += strOutputEvent;
	m_strXISL += "\">\r\n";
	m_strXISL += "<![CDATA[\r\n";

	if(m_nOutputEvent == ID_FSMEVENT_CHARACTER)
	{
		m_strXISL += "<param name=\"mask\">";
		m_strXISL += m_strMaskID;
		m_strXISL += "</param>\r\n";
	}
	else if(m_nOutputEvent == ID_FSMEVENT_SPEECH)
	{
		CString strText;
		m_strXISL += "<param name=\"text\">";
		GetText(strText);
		m_strXISL += strText;
		m_strXISL += "</param>\r\n";
		m_strXISL += "<param name=\"expression\">";
		m_strXISL += FSM_EXPRESSION_PARAM[m_nParam1];
		m_strXISL += "</param>\r\n";
		m_strXISL += "<param name=\"endsync\">";
		if(m_bEndSync)
			m_strXISL += "on";
		else
			m_strXISL += "off";
		m_strXISL += "</param>\r\n";
	}
	else if(m_nOutputEvent == ID_FSMEVENT_AUTONOMOUS)
	{
		m_strXISL += "<param name=\"action\">";
		m_strXISL += FSM_AUTONOMOUS_PARAM[m_nParam1];
		m_strXISL += "</param>\r\n";
	}
	else if(m_nOutputEvent == ID_FSMEVENT_EXPRESSION)
	{
		m_strXISL += "<param name=\"expression\">";
		m_strXISL += FSM_EXPRESSION_PARAM[m_nParam1];
		m_strXISL += "</param>\r\n";
		char chrParam[10];
		m_strXISL += "<param name=\"dur\">";
		m_strXISL += itoa(m_nParam2,chrParam,10);
		m_strXISL += "</param>\r\n";
	}
	else if(m_nOutputEvent == ID_FSMEVENT_MOTION)
	{
		m_strXISL += "<param name=\"action\">";
		m_strXISL += FSM_MOTION_PARAM[m_nParam1];
		m_strXISL += "</param>\r\n";
		char chrParam[10];
		m_strXISL += "<param name=\"id\">";
		m_strXISL += itoa(m_nParam2,chrParam,10);
		m_strXISL += "</param>\r\n";
	}
	m_strXISL += "]]>\r\n</output>\r\n";
	return m_strXISL;
}


BOOL CXISLOutputFSM::SetAttribute(LPCTSTR lpszEvent,LPCTSTR lpszParam)
{
	if(strcmp(lpszEvent,XISL_OUTPUT_EVENT[ID_FSMEVENT_CHARACTER]) == 0)
		m_nOutputEvent = ID_FSMEVENT_CHARACTER;
	else if(strcmp(lpszEvent,XISL_OUTPUT_EVENT[ID_FSMEVENT_SPEECH]) == 0)
	{
		m_pTextList = new CPtrList;
		m_nOutputEvent = ID_FSMEVENT_SPEECH;
	}
	else if(strcmp(lpszEvent,XISL_OUTPUT_EVENT[ID_FSMEVENT_AUTONOMOUS]) == 0)
		m_nOutputEvent = ID_FSMEVENT_AUTONOMOUS;
	else if(strcmp(lpszEvent,XISL_OUTPUT_EVENT[ID_FSMEVENT_EXPRESSION]) == 0)
		m_nOutputEvent = ID_FSMEVENT_EXPRESSION;
	else if(strcmp(lpszEvent,XISL_OUTPUT_EVENT[ID_FSMEVENT_MOTION]) == 0)
		m_nOutputEvent = ID_FSMEVENT_MOTION;
	else
	{
		AfxMessageBox("`ĂȂeventł",MB_OK|MB_APPLMODAL|MB_ICONEXCLAMATION,0);
		return FALSE;
	}

	CString strParam = lpszParam;
	CString strParamName;
	CString strValue;
	int nIndex=0,nStart=0,nEnd=0;
	int nParamCount=0;
	while(1)
	{
		nIndex = strParam.Find("<param",nIndex);
		if(nIndex==-1)
			break;

		nIndex = strParam.Find("name",nIndex);
		nStart = strParam.Find("\"",nIndex);
		nStart++;
		nEnd = strParam.Find("\"",nStart);
		strParamName = strParam.Mid(nStart,nEnd-nStart);

		nStart = strParam.Find(">",nEnd);
		nStart++;
		nEnd = strParam.Find("</param",nStart);
		strValue = strParam.Mid(nStart,nEnd-nStart);
		nIndex = nEnd + 1;

		if(strParamName.Compare("text")==0)
		{
			if(m_nOutputEvent != ID_FSMEVENT_SPEECH)
				return FALSE;
			m_strText = strValue;
			if(!SetText(m_strText,m_nParam1,m_bEndSync))
				return FALSE;
			nParamCount+=3;
		}
		else if(strParamName.Compare("mask")==0)
		{
			if(m_nOutputEvent != ID_FSMEVENT_CHARACTER)
				return FALSE;
			m_strMaskID = strValue;
			nParamCount+=3;
		}
		else if(strParamName.Compare("endsync")==0)
		{
			if(m_nOutputEvent != ID_FSMEVENT_SPEECH)
				return FALSE;
			if(strValue.Compare("on")==0)
				m_bEndSync = TRUE;
			else
				m_bEndSync = FALSE;
			nParamCount++;
		}
		else if(strParamName.Compare("expression")==0)
		{
			if(m_nOutputEvent != ID_FSMEVENT_SPEECH && m_nOutputEvent != ID_FSMEVENT_EXPRESSION)
				return FALSE;
			int nExp=ID_FSMEXPRESSION_HAPPY;
			while(1)
			{
				if(nExp > ID_FSMEXPRESSION_NEUTRAL)
				{
					AfxMessageBox("<param name=\"expression\">̒lsł"
						,MB_OK|MB_APPLMODAL|MB_ICONEXCLAMATION,0);
					return FALSE;
				}
				if(strcmp(FSM_EXPRESSION_PARAM[nExp],strValue) == 0)
					break;
				nExp++;
			}
			m_nParam1 = nExp;
			nParamCount++;
		}
		else if(strParamName.Compare("dur")==0)
		{
			if(m_nOutputEvent != ID_FSMEVENT_EXPRESSION)
				return FALSE;

			m_nParam2 = atoi(strValue);
			if(m_nParam2 < 0)
			{
				AfxMessageBox("<param name=\"dur\">̒lsł"
					,MB_OK|MB_APPLMODAL|MB_ICONEXCLAMATION,0);
				return FALSE;
			}
			nParamCount++;
		}
		else if(strParamName.Compare("action")==0)
		{
			if(m_nOutputEvent == ID_FSMEVENT_AUTONOMOUS)
			{
				int nAct=ID_FSMAUTONOMOUS_BLINK;
				while(1)
				{
					if(nAct > ID_FSMAUTONOMOUS_STOP)
					{
						AfxMessageBox("<param name=\"action\">̒lsł"
							,MB_OK|MB_APPLMODAL|MB_ICONEXCLAMATION,0);
						return FALSE;
					}
					if(strcmp(FSM_AUTONOMOUS_PARAM[nAct],strValue) == 0)
						break;
					nAct++;
				}
				m_nParam1 = nAct;
				nParamCount+=3;
			}
			else if(m_nOutputEvent == ID_FSMEVENT_MOTION)
			{
				int nAct=ID_FSMMOTION_LISTEN;
				while(1)
				{
					if(nAct > ID_FSMMOTION_REFUSE)
					{
						AfxMessageBox("<param name=\"action\">̒lsł"
							,MB_OK|MB_APPLMODAL|MB_ICONEXCLAMATION,0);
						return FALSE;
					}
					if(strcmp(FSM_MOTION_PARAM[nAct],strValue) == 0)
						break;
					nAct++;
				}
				m_nParam1 = nAct;
				nParamCount+=2;
			}
			else
				return FALSE;
		}
		else if(strParamName.Compare("id")==0)
		{
			if(m_nOutputEvent != ID_FSMEVENT_MOTION)
				return FALSE;

			m_nParam2 = atoi(strValue);
			if(m_nParam2 < 0 || m_nParam2 > 3)
			{
				AfxMessageBox("<param name=\"id\">̒lsł"
					,MB_OK|MB_APPLMODAL|MB_ICONEXCLAMATION,0);
				return FALSE;
			}
			nParamCount++;
		}
	}
	return TRUE;
}
